/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
import java.io.PrintWriter; import lotus.domino.*;
/**
 * 
 * @author Thomas Ekert
 *
 */
public class WebAgentXML extends AgentBase {

	public void NotesMain() {
		PrintWriter out = getAgentOutput();
		
		Document doc=null, nextdoc=null;
		DocumentCollection collection=null;
		try {
			Session session = getSession();
			AgentContext agentContext = session.getAgentContext();
			collection = agentContext.getCurrentDatabase().getAllDocuments();
			out.println ("Content-Type: text/xml\n\n");
			out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			out.println("<alldocuments>");
			doc = collection.getFirstDocument();
			while (doc != null) {
				nextdoc = collection.getNextDocument();
				out.println("<document unid=\"" + doc.getUniversalID()
						+ "\">\n<form>" + doc.getItemValueString("Form")
						+ "\n</form></document>");
				if (doc != null) {doc.recycle();}
				doc=nextdoc;
			}
			out.println ("</alldocuments>");
		} catch(Exception e) {
			e.printStackTrace(out);
		} finally {
			try {
				if (doc != null) {doc.recycle();}
				if (nextdoc != null) {nextdoc.recycle();}
				if (collection != null) {collection.recycle();}
			} catch (NotesException e1) {
				e1.printStackTrace();
			}
		}
	}
}
